<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ParceiroRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [

            'nome'=>'required|max:100',
            'codigo'=>'nullable|max:255',
            'nomedoresponsavel'=>'required|max:80',
            'telefonedoresponsavel'=>'nullable|numeric',
            'emaildoresponsavel'=>'nullable|email|max:80',
        ];
    }

    public function messages()
    {
     
        return [
                'required'=>'Este campo é obrigatório.',
                'numeric'=>'Insira um valor de geolocalização válido.',
                'max'=>'Este campo deve ter no máximo :max caracteres.',
                'email' => 'O campo deve ser do tipo Email'
            ];
    }
}
